import flet as ft


def main(page: ft.Page):
    page.title = "Пример счетчика Flet"
    page.vertical_alignment = ft.MainAxisAlignment.CENTER

    # поле для числа
    txt_number = ft.TextField(
        value="0",
        text_align=ft.TextAlign.RIGHT,
        width=100,
    )

    # обработчики кнопок
    def minus_click(e):
        txt_number.value = str(int(txt_number.value) - 1)
        page.update()

    def plus_click(e):
        txt_number.value = str(int(txt_number.value) + 1)
        page.update()

    # добавляем на страницу строку с кнопками и полем
    page.add(
        ft.Row(
            [
                ft.ElevatedButton("-", on_click=minus_click),
                txt_number,
                ft.ElevatedButton("+", on_click=plus_click),
            ],
            alignment=ft.MainAxisAlignment.CENTER,
        )
    )


if __name__ == "__main__":
    # Запуск как настольное приложение (в окне)
    ft.app(target=main)

    # Если нужно как веб-приложение в браузере, то вместо строки выше используй:
    # ft.app(target=main, view=ft.WEB_BROWSER)
